type 'a stream =
  | Eps :
      'a stream Lazy.t -> 'a stream
  | Cons :
      'a * 'a stream Lazy.t -> 'a stream

type 'a value = | P : 'a -> 'a value | Abs : 'a value

type 'a cstream = 'a value stream

type clock = bool stream
           
let rec const ck v =
  match ck with
  | Eps(ck) -> Eps(lazy (const (Lazy.force ck) v))
  | Cons(c, ck) -> Cons((if c then P(v) else Abs),
                        lazy (const (Lazy.force ck) v))

let rec extend fs xs =
  match fs, xs with
  | Eps(fs), Eps(xs) ->
     Eps(lazy (extend (Lazy.force fs) (Lazy.force xs)))
  | Cons(P f, fs), Cons(P x, xs) ->
     Cons(P (f x), lazy (extend (Lazy.force fs) (Lazy.force xs)))
  | Cons(Abs, fs), Cons(Abs, xs) ->
     Cons(Abs, lazy (extend (Lazy.force fs) (Lazy.force xs)))
  | Cons(Abs, fs), Cons(P _, _) ->
     Cons(Abs, lazy (extend (Lazy.force fs) xs))
  | Cons(P _, _), Cons(Abs, xs) ->
     Cons(Abs, lazy (extend fs (Lazy.force xs)))
  | Eps(fs), _ -> Eps(lazy (extend (Lazy.force fs) xs))
  | _, Eps(xs) -> Eps(lazy (extend fs (Lazy.force xs)))
                     
let rec fby xs ys =
  match xs with
  | Eps(xs) -> Eps(lazy (fby (Lazy.force xs) ys))
  | Cons(Abs, xs) -> Cons(Abs, lazy (fby (Lazy.force xs) ys))
  | Cons(P v, xs) -> Cons(P v, fby1 v xs ys

and fby1 v pre v ys

let pair xs ys =
  extend (extend (const (fun x y -> (x, y))) xs) ys

let fst xs = extend (const (fun (x, _) -> x)) xs
let snd xs = extend (const (fun (_, y) -> y)) xs

let notl xs = extend (const (fun x -> not x)) xs
let andl xs ys = extend (extend (const (fun x y -> x && y)) xs) ys

let plusl xs ys = extend (extend (const (fun x y -> x + y)) xs) ys

(* Attention: ce code ne marche pas !! *)
let rec whenc xs cs =
  match xs, cs with
  | Eps(lazy xs), Eps(lazy cs) -> Eps(lazy (whenc xs cs))
  | Cons(x, lazy xs), Cons(c, lazy cs) ->
     if c then Cons(x, lazy (whenc xs cs))
     else Eps(lazy (whenc xs cs))
  | Eps(lazy xs), _ -> Eps(lazy (whenc xs cs))
  | _, Eps(lazy cs) -> Eps(lazy (whenc xs cs))

let rec whenc xs cs =
  match xs, cs with
  | Eps(xs), Eps(cs) ->
     Eps(lazy (whenc (Lazy.force xs) (Lazy.force cs)))
  | Cons(x, xs), Cons(c, cs) ->
     if c then Cons(x, lazy (whenc (Lazy.force xs) (Lazy.force cs)))
     else Eps(lazy (whenc (Lazy.force xs) (Lazy.force cs)))
  | Eps(xs), _ -> Eps(lazy (whenc (Lazy.force xs) cs))
  | _, Eps(cs) -> Eps(lazy (whenc xs (Lazy.force cs)))

(* Attention: ce code ne marche pas !! *)
let rec merge cs xs ys =
  match cs, xs, ys with
  | Eps(lazy cs), Eps(lazy xs), Eps(lazy ys) ->
     Eps(lazy (merge cs xs ys))
  | Cons(true, lazy cs), Cons(x, lazy xs), _ ->
     Cons(x, lazy (merge cs xs ys))
  | Cons(false, lazy cs), _, Cons(y, lazy ys) ->
     Cons(y, lazy (merge cs xs ys))
  | Eps(lazy cs), _, _ -> Eps(lazy (merge cs xs ys))
  | Cons(true, _), Eps(lazy xs), _ -> Eps(lazy (merge cs xs ys))
  | Cons(false, _), _, Eps(lazy ys) -> Eps(lazy (merge cs xs ys))

let rec merge cs xs ys =
  match cs, xs, ys with
  | Eps(cs), Eps(xs), Eps(ys) ->
     Eps(lazy (merge (Lazy.force cs) (Lazy.force xs) (Lazy.force ys)))
  | Cons(true, cs), Cons(x, xs), _ ->
     Cons(x, lazy (merge (Lazy.force cs) (Lazy.force xs) ys))
  | Cons(false, cs), _, Cons(y, ys) ->
     Cons(y, lazy (merge (Lazy.force cs) xs (Lazy.force ys)))
  | Eps(cs), _, _ ->
     Eps(lazy (merge (Lazy.force cs) xs ys))
  | Cons(true, cs), Eps(xs), _ ->
     Eps(lazy (merge (Lazy.force cs) (Lazy.force xs) ys))
  | Cons(false, _), _, Eps(ys) ->
     Eps(lazy (merge cs xs (Lazy.force ys)))
  
                     
let fix f =
  let rec y = Eps(lazy (f y)) in
  y

(* exemples *)
(* 1. half *)
let half () =
  let f = fun x -> notl (pre false x) in
  fix f

let half () =
  let f = fun x -> (pre true (notl x)) in
  fix f

(* 2. nat *)
let from v =
  let f = fun x -> pre v (plusl x (const 1)) in
  fix f

(* 2. unbounded memory *)
let monster () =
  let t = const true in
  let h = half () in
  andl t (whenc t h)
  
(* 3. N-synchrone *)
let n_synchrone () =
  let t = from 0 in
  let h = half () in
  plusl (whenc t (notl h)) (whenc t h)
  
let rec list_of n xs =
  if n = 0 then []
  else match xs with
       | Eps(lazy xs) -> None :: (list_of (n-1) xs)
       | Cons(x, lazy xs) -> Some(x) :: (list_of (n-1) xs)

let rec out print n xs =
  if n = 0 then ()
  else match xs with
       | Eps(lazy xs) -> print_string "."; out print (n-1) xs
       | Cons(x, lazy xs) -> print x; out print (n-1) xs

let print x = print_int x; print_string " "

let print_bool x = print_string (if x then "true" else "false")

