(* signal as sequences, i.e., functions from natural numbers to values *)
(* Warning: whereas this representation leads to a simple and direct
 *- interpreter for a data-flow langage of streams;
 *- it is totally useless in practice for computation.
 *- To be convinced, think of the direct execution of the fibonacci sequence
 *- defined as:
 *- fibo(n) = if n = 0 then 1 else fibo(n-1)+fibo(n-2)
 *- It is exponential in time and space whereas it can be computed
 *- incrementally with only two registers
 *- moreover, all the element are recomputed from the very begining. For
 *- definitions that are linear (e.g., factorial), it takes O(n) to compute
 *- the n-the element.
 *- finally, nothing ensure the absence of deadlocks which correspond here
 *- to unbounded recursion *)

type 'a sequence = int -> 'a

let const v n = v
let extend f x n = (f(n)) (x(n))

let lift1 f x = extend (const f) x
let lift2 f x y = extend (extend (const f) x) y
                
let notl x = lift1 (fun x -> not x) x
let plusl x y = lift2 (+) x y
let minusl x y = lift2 (-) x y
let andl x y = lift2 (&&) x y
let eql x y = lift2 (=) x y
let pre v x n = if n = 0 then v else x(n-1)
let fby x y n = if n = 0 then x 0 else y(n-1)
let next x n = x (n+1)
             
let mux x y z =
  extend (extend (extend (const
                            (fun x y z -> if x then y else z))
                    x) y) z
              
(* cumulative and index functions *)
(* [cumul(h)(n)] returns the sum of ones in h up to index n *)
let rec cumul(h)(n) = (if h(n) then 1 else 0) +
                        (if n = 0 then 0 else cumul(h)(n-1))
(* [index(h)(n)] returns the index of the n-th one in h *)
let rec index(h)(n) = index_aux(h)(0)(n)

and index_aux(h)(i)(n) =
  if h(i) then if n = 1 then i else index_aux(h)(i+1)(n-1)
  else index_aux(h)(i+1)(n)

(* property *)
(* cumul(h)(index(h))(n) = n *)
  
(* filtering and merge *)
let whenc x h n = x(index(h)(n+1))
let when_notc x h n = x(index(notl h)(n+1))
let merge h x y n = if h(n) then x(cumul(h)(n)) else y(cumul(notl h)(n))

(* reset. [reset(h)(n)] returns the greatest *)
(* index i in [0..n] where h(i) = true *)
(* if there is not, returns 0 *)
let reset(h)(n) =
  let rec o n = if n = 0 then 0
                else if h n then n else o(n-1) in
  o(n)
  
(* Fixpoint operator *)
let fix : ('a sequence -> 'a sequence) -> 'a sequence =
  fun f n -> let rec o n = f o n in o n

(* Examples *)
let half () = let rec half n = pre false (notl half) n in half
let from v =
  let rec f n = pre 0 (plusl f (const 1)) n in f

let incr v x n = pre v (plusl x (const 1)) n
let from v = fix (incr (v(0)))

let sum x =
  (* In Zelus, write: [let rec y = (0 fby y) + x in y] *)
  fix (fun y -> plusl (pre 0 y) x)
             
(* Deadlock / infinite loop *)
(* to test, type [deadlock 42] *)
let id x n = x n
let deadlock n = fix id n

(* to test, type [deadlock 42] *)
let deadlock n =
  let x = const true in
  whenc x (const false) n

(* non synchronous *)
(* see how long it is to compute unbounded 10000 ! *)
let unbounded =
  let x = const true in
  let h = half () in
  andl (whenc x h) x

(* the bottom element *)
let rec eps n = eps n

(* semantics of a simple language with block structures *)
let cond_act (c: bool sequence) f g x =
  (* cond_act c f g x = merge c (f (x when c)) (g (x whenot c))) *)
  merge c (f (whenc x c)) (g (when_notc x c))

(* after. [after x k] returns the sub-sequence of x *)
(* which starts at index k *)
let after x k = fun n -> x (n+k)

(* reset_act :: 'a. ('b. 'b -> 'b) -> 'a -> 'a -> 'a *)
let reset_act f x c =
  fun n ->
    let k = reset c n in
    f (after x k)(n-k)

let every_n v =
  (* x = let px = n fby x in
         if px = 1 then n else px - 1 *)
  let m =
    fix (fun x ->
        let px = fby v x in
        mux (eql px (const 1)) v (minusl px (const 1))) in
  eql m v

let main1 n =
  (* reset from 0 every (every_n n) *)
  reset_act from (const 0) (every_n (const n))

let main2 () =
  let nat = from (const 0) in
  reset_act sum nat (every_n (const 6))
  (* let nat = from 0 in
     reset integr nat every (every_n 6) *)
  
let list n x = 
  let rec listrec i =
    x i :: (if i = n then [] else listrec (i+1)) in
  listrec 0

let output n x =
  let rec loop i =
    print_int i; print_string " ";
    print_int (x i); print_newline ();
    if i < n then loop (i+1) in
  loop 0

(* main examples *)
let f _ =
  output 40
    (reset_act (fun _ -> (sum (from (const 0)))) (const 0) (const false))

let _ = output 40 (mux (every_n (const 6)) (const 1) (const 0))

          
                                          
