-- Lustre and Lucid Synchrone operators in Haskell
-- A Kahnian semantics

module Kahn where

-- streams are values of the following recursive data-type
data Stream a = Cons !a (Stream a)

constant v = Cons v (constant v)

extend (Cons f fs) (Cons x xs) = Cons (f x) (extend fs xs)

pre v xs = Cons v xs
(Cons x xs) `fby` ys = Cons x ys

pair (xs, ys) = extend (extend (constant (\x y -> (x, y))) xs) ys

plus1 xs = extend (constant (\x -> x + 1)) xs
fst xs = extend (constant (\(x, _) -> x)) xs
snd xs = extend (constant (\(_, y) -> y)) xs

notl xs = extend (constant (\x -> not x)) xs
andl xs ys = extend (extend (constant (\x y -> x && y)) xs) ys
eql xs ys = extend (extend (constant (\x y -> x == y)) xs) ys

mux cs xs ys = extend (extend (extend (constant (\c x y -> if c then x else y)) cs) xs) ys

plusl xs ys = extend (extend (constant (\x y -> x + y)) xs) ys

xs `arrow` ys = mux ((constant True) `fby` (constant False)) xs ys

(Cons x xs) `when` (Cons c cs) = if c then Cons x (xs `when` cs) else (xs `when` cs)

x `whenot` c = x `when` (notl c)
                
merge (Cons c cs) xs ys = if c then case xs of Cons x xs -> Cons x (merge cs xs ys) else case ys of Cons y ys -> Cons y (merge cs xs ys)

fix f = let y = f y in y
fix2 f = let xy = fix (\xy -> pair (f (fst xy, snd xy))) in (fst xy, snd xy)

-- (* examples *)
half1 () = let f = \x -> notl (pre False x) in fix f

half2 () = let f = \x -> (pre True (notl x)) in fix f

from v = let f = \x -> v `fby` (plusl x (constant 1)) in fix f

integr x' = fix (\o -> plusl x' (pre 0 o))

zero = let f = \x -> pre 0 x in fix f

-- this one does not run in bounded memory
unbounded () = let t = constant True in let h = half1 () in andl (t `when` h) t

-- the following two deadlock
deadlock1 () = let deadlock = fix (\x -> x) in deadlock
deadlock2 () = let deadlock = fix (\x -> plusl x (constant 1)) in deadlock

n_synchrony () = let t = from (constant 0) in let h = half1 () in plusl (t `whenot` h) (t `when` h)

list_of n xs = if n == 0 then [] else case xs of Cons x xs -> x : (list_of (n-1) xs)


