From Coq Require Import Extraction.
Set Implicit Arguments.
Require Import Coq.Init.Datatypes.

Require Import List.
Import ListNotations.
(* Import Kahn_lazy_epsilon. *)

(* Control structures - The reset *)

CoFixpoint false_true (cs : Stream bool) : Stream bool :=
  match cs with
  | Eps(xs) => Eps(false_true xs)
  | Cons x xs => Cons false xs
  end.

Definition while_not (x : Stream bool) : Stream bool :=
  let f := fun o => andl (pre true o) (notl x) in
  lfp f.

Definition do_unless { A B : Type }
           (c : Stream A -> Stream bool)
           (f : Stream A -> Stream B)
           (g : Stream A -> Stream B)
           (x : Stream A) : Stream B :=
  let cv := while_not (c x) in
  merge cv (f (when x cv)) (g (when x (notl cv))).

CoFixpoint merge_unless { A : Type } :
  Stream bool -> Stream A -> Stream A -> Stream A :=
  fun cs xs ys =>
    match cs with
    | Eps cs => Eps (merge_unless cs xs ys)
    | Cons c cs' =>
        match c with
        | true => ys
        | false =>
            match xs with
            | Eps(xs) => Eps (merge_unless cs xs ys)
            | Cons x xs => Cons x (merge_unless cs xs ys)
            end
        end
    end.

CoFixpoint after_unless {A : Type } :
  Stream A -> Stream bool -> Stream A :=
  fun xs cs =>
    match cs with
    | Eps cs => Eps(after_unless xs cs)
    | Cons c cs =>
        if c then xs else Eps(after_unless xs cs)
    end.

Definition do_unless_two { A B : Type } :
  (Stream A -> Stream bool) -> (Stream A -> Stream B) ->
  (Stream A -> Stream B) -> Stream A -> Stream B :=
  fun c f g x =>
    let cv := false_true (c x) in
    merge_unless cv (f x) (g (after_unless x cv)).

(* The following two definitions do not follow the guard conditions *)
(* for CoFixpoints *)
(*
CoFixpoint reset_two { A : Type }
   (f : Stream A -> Stream A)
   (c : Stream A -> Stream bool)
   (x : Stream A) :=
     do_unless_two c f (reset_two f c) x.
 *)

(*
CoFixpoint reset { A : Type }
   (f : Stream A -> Stream A)
   (c : Stream A -> Stream bool)
   (x : Stream A) :=
     do_unless (fun x => false_true (c x)) f (reset f c) x.
*)

CoFixpoint tl { A : Type } : Stream A -> Stream A :=
  fun xs =>
    match xs with | Cons _ xs => xs | Eps(xs) => Eps(tl(xs))
    end.

(* The following is adapted from an idea by Paul Jeanmaire, Oct. 2021 *)
(* not finished yet! *)
(* My intuition is that one can turn a recursive definition (Fixpoint) *)
(* which may not be *)
(* terminate into a corecursive definitin (CoFixpoint) such that *)
(* any time a function application f x needs its argument x and this argument *)
(* is not yet ready (NotYet(x)), returns (NotYet(f x)); when this argument is *)
(* Ready(v), apply f to v *)
(* This intuition is adapted to stream functions. *)
CoFixpoint reset_acc { A B : Type } (f : Stream A -> Stream B)
           (ys : Stream B)
           (rs : Stream bool) (xs : Stream A) : Stream B :=
  match rs with
  | Eps(rs) => Eps(reset_acc f ys rs xs)
  | Cons r rs =>
    if r then
      Eps(reset_acc_tl_xs f (f xs) rs xs)
    else
      Eps(reset_acc_tl_rs_xs_ys f ys rs xs)
  end
with
reset_acc_tl_ys { A B : Type } (f : Stream A -> Stream B)
           (ys : Stream B)
           (rs : Stream bool) (xs : Stream A) : Stream B :=
  match ys with
  | Eps(ys) => Eps(reset_acc_tl_ys f ys rs xs)
  | Cons y ys => Eps(reset_acc f ys rs xs)
  end
with
reset_acc_tl_rs_xs { A B : Type } (f : Stream A -> Stream B)
           (ys : Stream B)
           (rs : Stream bool) (xs : Stream A) : Stream B :=
  match rs with
  | Eps(rs) => Eps(reset_acc_tl_rs_xs f ys rs xs)
  | Cons _ rs => Eps(reset_acc_tl_xs f ys rs xs)
  end
with
reset_acc_tl_xs { A B : Type } (f : Stream A -> Stream B)
           (ys : Stream B)
           (rs : Stream bool) (xs : Stream A) : Stream B :=
  match xs with
  | Eps(xs) => Eps(reset_acc_tl_xs f ys rs xs)
  | Cons x xs => Eps(reset_acc f ys rs xs)
  end
with
reset_acc_tl_rs_xs_ys { A B : Type } (f : Stream A -> Stream B)
           (ys : Stream B)
           (rs : Stream bool) (xs : Stream A) : Stream B :=
    match ys with
      | Eps(ys) => Eps(reset_acc_tl_rs_xs_ys f ys rs xs)
      | Cons y ys => Cons y (reset_acc_tl_xs f ys rs xs)
    end.


(* The paper Ch. Paulin defines a general fixpoint operators on CPOs
 *- that could be used here [A Constructive Semantics of Kahn Networks]
 *- I try a more ad-hoc version that computes the sequence
 *- f(bot), f^2(bot), ..., f^n(bot) and resets it every time [r] is true *)
CoFixpoint lfpaux_reset
           { A : Type } (f : Stream A -> Stream A) (r : Stream bool)
           (v : Stream A) (j : nat) (n : nat) : Stream A :=
  match r with
  | Eps(r) =>
      Eps (lfpaux_reset f r v j n)
  | Cons c r =>
      let j := if c then 0 else j in
      let n := if c then 0 else n in
      let v := if c then bot A else v in
      let v := f v in
      let vn := ask_option v j n in
      match vn with
      | None => Eps(lfpaux_reset f r v j (n+1))
      | Some(vn) => Cons vn (lfpaux_reset f r v (j+1) (n+1))
      end
  end.

Definition lfp_reset { A : Type }
           (f : Stream A -> Stream A) (r : Stream bool) :=
  lfpaux_reset f r (bot A) 0 0.
(* Examples *)

Definition eql : Stream nat -> Stream nat -> Stream bool :=
  fun xs ys =>
    extend (extend (const (fun x y => Nat.eqb x y)) xs) ys.

Definition cond (_: unit) := eql (from (const 0)) (const 42).

Definition r1 := reset_acc from (from (const 0)) (cond tt) (const 0).

Eval vm_compute in (list_of 1000 r1).
(*
Definition r1 :=
  list_of 100 (do_unless cond from (do_unless cond from from) (constant 0)).
*)
(*
Definition r2 :=
  list_of 100 (reset_two from cond (constant 0)).
*)

