module Control where

import Kahn

-- Control structures - The reset

false_true (Cons _ cs) = Cons False cs
-- semantically, false_true xs = (constant True) `arrow` xs

while_not x = fix (\o -> andl (pre True o) (notl x))

do_unless c f g x =
  let cv = while_not (c x) in
  merge cv (f (x `when` cv)) (g (x `whenot` cv))

-- reset is defined as a recursive function
-- note that this version will use more and more memory
-- this is because the merge doesn't know that once its input condition
-- is false, it will never be true anymore.
reset f c x =
  let reset x = do_unless (\x -> false_true (c x)) f reset x in reset x

-- the following merge operator models a sequence; once the
-- condition is true, its returns the right branch.
merge_unless (Cons c cs) xs ys =
  case c of
    True -> ys
    False ->
      case xs of
        Cons x xs -> Cons x (merge_unless cs xs ys)

after_unless xs (Cons c cs) =
  if c then xs else after_unless xs cs

-- the sequence operator between two behaviors (i.e.g, systems)
do_unless_two c f g x =
  let cv = c x in
  merge_unless cv (f x) (g (after_unless x cv))

-- the following reset is written recursively through
-- a sequence operator.
reset_two f c x =
  let reset x = do_unless (\x -> false_true (c x)) f reset x in reset x

-- Examples

cond x = eql (from (constant 0)) (constant 42)

r1 = list_of 100 (do_unless cond from (do_unless cond from from) (constant 0))

r2 = list_of 100 (reset_two from cond (constant 0)) -- cond


