#include <stdio.h>
#include "ndfa.h"

int main(int argc, char *argv[]){
  if (argc < 2){
    printf("Veuillez entrer un mot en minuscule\n");
    return 1;
  }
  ndfa a = ndfa_init(2);
  a.I = singleton(0);
  a.F = singleton(1);
  for (int c = 'a'; c <= 'z'; c = c + 1){
    a.delta[0][c] = 1;
    a.delta[1][c] = 2;
  }
  a.delta[0][' '] = 1;
  a.delta[1][' '] = 2;
  a.delta[0]['m'] = 3;
  a.delta[0]['b'] = 3;
  a.delta[0]['p'] = 3;

  if (accept(a, argv[1])) printf("Ça touche\n");
  else printf("Ça ne touche pas\n");

  return 0;
}
