clear all
seed= 1;
randn('state',seed);
rand('state',seed);

gamma = 2;
pi1 = .9;
pi2 = 1-pi1;
sigma1 = 1;
sigma2 = 20;


% compute asymptotic bounds
deltas = (0.01:.01:1)*2*gamma;
bias_bound = deltas*0 + Inf;
var_bound = deltas*0 + Inf;

for idelta = 1:length(deltas)
    delta = deltas(idelta);
    if delta > 1, deltaloc = 1; else deltaloc = delta; end
    kappas(idelta) = gamma/deltaloc * ( sigma1*pi1 + sigma2*pi2 ) - (sigma1+sigma2) + sqrt( (gamma/deltaloc * ( sigma1*pi1 + sigma2*pi2 ) - (sigma1+sigma2))^2 + 4*sigma1*sigma2*(gamma/deltaloc-1) );
    kappas(idelta) = kappas(idelta) / 2;
    df2sn(idelta) = gamma* ( pi1*sigma1^2 /(sigma1+kappas(idelta))^2 + pi2*sigma2^2 /(sigma2+kappas(idelta))^2 ) ;
    
    if delta<1
        var_bound(idelta) =  delta / ( 1- delta);
        bias_bound(idelta) = 1 / ( 1 - delta) * kappas(idelta) * ( pi1 * sigma1 / ( sigma1 + kappas(idelta) )  +  pi2 * sigma2 / ( sigma2 + kappas(idelta) ) );
    else
        var_bound(idelta) =  1 / ( delta -1 ) + df2sn(idelta)/( 1 - df2sn(idelta) );
        bias_bound(idelta) = kappas(idelta)^2 *   ( pi1 * sigma1 / ( sigma1 + kappas(idelta) )^2  +  pi2 * sigma2 / ( sigma2 + kappas(idelta) )^2 );
        bias_bound(idelta) = bias_bound(idelta) / ( 1 - df2sn(idelta) ) + 1/(delta-1) * ( pi1 * sigma1 / ( sigma1 + kappas(idelta) )  +  pi2 * sigma2 / ( sigma2 + kappas(idelta) ) ) * kappas(idelta);
        
        
        
    end
end


% simulations
nrep = 10;
ns = round(10.^[1:1:3]);
for in = 1:length(ns)
    n = ns(in);
    d = ceil(gamma*n);
    
    for irep = 1:nrep
        % sample a problem
        a = rand(d,1);
        temp = randn(d,d); temp = temp + temp';
        [u,e] = eig(temp);
        
        Sigma = u * diag(sigma1 * ( a < pi1) + sigma2 * ( a >= pi1)) * u';
        Sigmasqrt = u * diag( sqrt( sigma1 * ( a < pi1) + sigma2 * ( a >= pi1))) * u';
        theta_ast = u*u' * randn(d,1) / sqrt(d);
        ms{in} = unique( ceil( deltas * n));
        
        X = sign(randn(n,d)) * Sigmasqrt;
        epsilon = randn(n,1);
        
        Sfull = sign(randn(d,max(ms{in})));
        
        for im = 1:length(ms{in})
            
            m = ms{in}(im);
            S = Sfull(:,1:m);
            
            
            if m < n
                
                SXXS =  S'*X'*X*S;
                thetabias =  S * ( SXXS \ ( S' * X' * X * theta_ast ) );
                thetavar =  S * ( SXXS \ (  S' * X' * epsilon ) );
                
                empRvar{in}(im,irep) = (thetavar)'*Sigma*(thetavar);
                empRbias{in}(im,irep) = (thetabias-theta_ast)'*Sigma*(thetabias-theta_ast);
                
            else
                
                
                SST = S*S';
                SSTX = SST*X';
                XSSX =  X*SSTX;
                thetabias = SSTX * ( XSSX \ ( X * theta_ast ) );
                thetavar =  SSTX * ( XSSX \  epsilon );
                
                empRvar{in}(im,irep) = (thetavar)'*Sigma*(thetavar);
                empRbias{in}(im,irep) = (thetabias-theta_ast)'*Sigma*(thetabias-theta_ast);
                
                
            end
            
            
        end
    end
end
for in = 1:length(ns)
    subplot(3,2,2*(in-1)+1);
    plot(deltas,var_bound,'r','linewidth',2);
    hold on;
    plot(ms{in}/ns(in),mean(empRvar{in},2),'b','linewidth',2);
    plot(ms{in}/ns(in), empRvar{in},'b:','linewidth',1);
    plot(deltas,var_bound,'r','linewidth',2);
    
    hold off
    axis([0 max(deltas) 0 6])
    legend('theoretical bound','empirical estimate');
    xlabel('\delta');
    ylabel('excess risks');
    title(sprintf('variance - n = %d',ns(in)),'fontweight','normal');
    set(gca,'fontsize',18);
    
    subplot(3,2,2*(in-1)+2);
    plot(deltas,bias_bound,'r','linewidth',2);
    hold on;
    plot(ms{in}/ns(in),mean(empRbias{in},2),'b','linewidth',2);
    plot(ms{in}/ns(in), empRbias{in},'b:','linewidth',1);
    plot(deltas,bias_bound,'r','linewidth',2);
    
    hold off
    axis([0 max(deltas) 0 6])
    legend('theoretical bound','empirical estimate');
    
    xlabel('\delta');
    ylabel('excess risks');
    title(sprintf('bias - n = %d',ns(in)),'fontweight','normal');
    set(gca,'fontsize',18);
end


