% ce fichier modele.cls s'appuie sur book.cls
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{modele}
              [2009/05/21 v1.0
Feuille de style Paris 2]

\LoadClass[12pt,a4paper,fleqn]{book}

\RequirePackage{etex}
\RequirePackage[latin1]{inputenc}
\RequirePackage[T1]{fontenc}
\RequirePackage[frenchb]{babel}
\RequirePackage{lmodern}
\RequirePackage{eurosym}
\RequirePackage{geometry}
\RequirePackage{lastpage}
\RequirePackage{graphicx}
%\RequirePackage{picins}
\RequirePackage{pifont}
\RequirePackage{eepic}
\RequirePackage{fancybox}
\RequirePackage{fancyhdr}
\RequirePackage{ifpdf}
\RequirePackage{pst-all}
\RequirePackage{pst-eucl}
\RequirePackage{tikz}
\RequirePackage{xcolor}
%\RequirePackage{xlop}
\RequirePackage[autolanguage]{numprint}
\RequirePackage{calc}
\RequirePackage{ifthen}
\RequirePackage{latexsym}
\RequirePackage{amsfonts}
\RequirePackage{amsmath}
\RequirePackage{amssymb}
\RequirePackage{amsthm}
\RequirePackage{mathrsfs}
\RequirePackage{frcursive}
\RequirePackage{multirow}
\RequirePackage{multicol}
\RequirePackage{array}
\RequirePackage{tabularx}
%\RequirePackage{colortab}
\RequirePackage{makeidx}
% Sur d'anciennes installations, il faut commenter les deux lignes suivantes 
% (\frenchbsetup):
\frenchbsetup{ReduceListSpacing=false, CompactItemize=false,
StandardItemLabels=true}% pour empecher frenchb de perturber enumitem
\RequirePackage{enumitem}
\setitemize{nolistsep}
\setitemize[1]{label=\textbullet}
\RequirePackage{ulem}
\RequirePackage{rotating}

\normalem

\newcommand{\colorulem}[1][black]{\bgroup
  \ifdim\ULdepth=\maxdimen\settodepth\ULdepth{(j}\advance\ULdepth.4pt\fi
  \markoverwith{\kern0em\vtop{\kern\ULdepth {\color{#1}\hrule height 1.4pt width .4em}}\kern0em}\ULon}

% Dfinitions du format de page
%\setlength{\hoffset}{-18pt}         
\setlength{\oddsidemargin}{20pt} % Marge gauche sur pages impaires
\setlength{\evensidemargin}{10pt} % Marge gauche sur pages paires
\setlength{\marginparwidth}{54pt} % Largeur de note dans la marge
\setlength{\textwidth}{460pt} % Largeur de la zone de texte (17cm)
\setlength{\marginparsep}{10pt} % Sparation de la marge
\setlength{\topmargin}{30pt} % Marge en haut
\setlength{\headheight}{30pt} % Haut de page
\setlength{\headsep}{30pt} % Entre le haut de page et le texte
\setlength{\footskip}{30pt} % Bas de page + sparation
\setlength{\textheight}{600pt} % Hauteur de la zone de texte
%\geometry{margin=2cm}
%\pagestyle{empty}

% definition des couleurs
\definecolor{bleu}{rgb}{0.4,0.2,1} \newrgbcolor{bleu}{0.4 0.2 1}
\definecolor{rouge}{rgb}{1,0,0} \newrgbcolor{rouge}{1 0 0}
\definecolor{vert}{rgb}{0.1,0.6,0} \newrgbcolor{vert}{0.1 0.6 0}
\definecolor{blanc}{rgb}{1,1,1} \newrgbcolor{blanc}{1 1 1}
\definecolor{noir}{rgb}{0,0,0} \newrgbcolor{noir}{0 0 0}
\definecolor{gris}{rgb}{0.5,0.5,0.5} \newrgbcolor{gris}{0.5 0.5 0.5}
\definecolor{grisclair}{rgb}{0.9,0.9,0.9} \newrgbcolor{grisclair}{0.9 0.9 0.9}
\definecolor{jorange}{rgb}{0.9,0.9,0} \newrgbcolor{jorange}{0.9 0.9 0}

% mise en valeur forte
\newcommand*{\strong}[1]{{\color{rouge}\bfseries#1}}

% mise en page des proprits, remarques et exemples
\theoremstyle{definition}
\newtheorem*{exemple}{Exemple}
\newtheorem{exemplenumerote}{Exemple}[subsection]
\renewcommand{\theexemplenumerote}{\arabic{exemplenumerote}}
\newtheorem*{exemples}{Exemples}
\newenvironment{sousexemples}{\leavevmode\begin{itemize}}{\end{itemize}}
\newtheorem*{remarques}{Remarques}
\newenvironment{sousremarques}{\leavevmode\begin{itemize}}{\end{itemize}}
\newtheorem*{propriete}{Proprit}
\newtheorem*{consequence}{Consquence}
\newenvironment{sousconsequence}{\leavevmode\begin{itemize}}{\end{itemize}}

% alignement multiple
\newenvironment{multialign*}{\[\renewcommand{\arraycolsep}{1.4pt}\begin{array}{lllllllllllll}}{\end{array}\]}

% loi et dcret
\newcommand{\loi}[1]{\large \itshape{#1}}
\newcommand{\decret}[1] {\normalsize \itshape{#1}}

%%%% debut macro %%%%
\makeatletter
\def\@makechapterhead#1{%
  \vspace*{50\p@}%
  {\parindent \z@ \raggedright \normalfont
    \interlinepenalty\@M
    \ifnum \c@secnumdepth >\m@ne
        \Huge\bfseries \thechapter\quad
    \fi
    \Huge \bfseries #1\par\nobreak
    \vskip 40\p@
  }}

\def\@makeschapterhead#1{%
  \vspace*{50\p@}%
  {\parindent \z@ \raggedright
    \normalfont
    \interlinepenalty\@M
    \Huge \bfseries  #1\par\nobreak
    \vskip 40\p@
  }}
\makeatother
%%%% fin macro %%%%

\endinput
%%
%% End of file `modele.cls'.

