% GENERATE RANDOM PROBLEM AND DO PATH FOLLOWING FOR ***UNBALANCED*** CLASSIFICATION
% USING KERNEL MATRICES DIRECTLY (INSTEAD OF KERNELS)

clear all

n = 500;            % number of datapoints
m = 3;              % number of variable
d = 3;              % dimension of the variables
seed = 22;          % seed of random number generator
noise = 1;          % amount of noise
unbalance = .1;     % amount of unbalance between classes

% DATA
% requires : Ks      cell array of kernel matrices (FORMAT = SINGLE si MATLAB7)
%            y       array of labels or responses
load kernels_labels_demo


n = length(y);          % number of data points
m = length(Ks);         % number of kernels

% define usual cost asymmetry
nplus = length(find(y==1));
nminus = length(find(y==-1));
rho = zeros(n,1);
rho(find(y==1)) = n / nplus / 2;
rho(find(y==-1))= n / nminus / 2;
y = [ y rho ];

% simulation parameters
ntotal = n;         % total number of points - useful if subsampling a large dataset
proptrain = .8;     % proportion of training data

% randomize order and separate training set and testing set
rand('state', seed);
randn('state', seed);
ind    = randperm(n);
ntotal = min( ntotal, n );
ntrain    = round(ntotal*proptrain);
ntest     = ntotal - ntrain;
indtrain = ind(1:ntrain);
indtest = ind(ntrain+1:ntotal);
ytrain    = y(indtrain,:);
ytest     = y(indtest,:);


% compute training kernel matrices and weights
Ks_train = cell(1,m);
Ks_test = cell(1,m);

for j=1:m
   Ks_train{j} = Ks{j}(indtrain,indtrain);
   Ks_test{j} = Ks{j}(indtrain,indtest);
    % normalize to unit trace
    trace_normalizer(j) = trace(Ks_train{j});
    Ks_train{j} = Ks_train{j} / trace_normalizer(j);
    Ks_test{j} = Ks_test{j} / trace_normalizer(j);

end
DS_POWER = 1;
ds = compute_ds(Ks_train,DS_POWER);
ds = ds / norm(ds);

loss.type='logistic_unbalanced';
efficient_type=1;
Kse_train = build_efficient_Ks(Ks_train,efficient_type);
Kse_test = build_efficient_Ks_test(Ks_test,0);
clear Ks_train Ks_test

% path following parameters
path_params.mu                  = 1e-3;      % parameter of log-barrier
path_params.EPS1                = 1e-10;     % precision parameters of Newton steps (very small and fixed)
path_params.EPS2                = 1e-2;      % precision parameter of tube around path (adaptive)
path_params.predictor_type      = 2;         % 1 : first order predictor, 2 : second order
path_params.efficient_predictor = 0;         % 1 : efficient predictor steps, 0 : full steps
path_params.efficient_eta       = 1;         % real value : threshold eta for corrector steps, 0 : no threshold
path_params.maxsigma            = 20;        % maximum value of sigma = -log(lambda);
path_params.newton_iter1        = 10;        % number of iterations with no modification
path_params.newton_iter2        = 6;         % delta number of iterations under which EPS2 is divided/multiplied by 2
path_params.maxdsigma           = 1;         % maximal step
path_params.mindsigma           = .004;      % minimal step
path_params.maxvalue_EPS2       = 1e-2;      % maximum value of tolerance for predictor steps


        
        
path = follow_entire_path(Kse_train,ytrain,loss,ds,path_params,Kse_test,ytest);

% plot
ind=1:2:size(path.etas,1);
rp=randperm(length(ind)); ind=ind(rp);
plot(path.sigmas(ind),path.etas(ind,:),'-');
axis([ 0 10 0 11] )
xlabel('-log(\lambda)','fontsize',24)
ylabel('\eta ','fontsize',24)
