% GENERATE RANDOM PROBLEM AND DO PATH FOLLOWING FOR CLASSIFICATION
% PLOT THE ETAS
% FIGURE 3 OF NIPS PAPER
clear all

n = 100;            % number of datapoints
m = 3;              % number of variable
d = 3;              % dimension of the variables
seed = 22;          % seed of random number generator
noise = 1;          % amount of noise
[x,y] = generate_random_problem(n,m,d,noise,seed,'classification');
p = size(x,2);

% simulation parameters
ntotal = 400;       % total number of points - useful if subsampling a large dataset
proptrain = .8;     % proportion of training data

% randomize order
rand('state', seed);
randn('state', seed);
ind    = randperm(size(x,1));
ntotal = min( ntotal, size(x,1) );
x      = x(ind(1:ntotal),:);
y      = y(ind(1:ntotal),:);

% separate training set and testing set
ntrain    = round(ntotal*proptrain);
ntest     = ntotal - ntrain;
xtrain    = x(1:ntrain,:);
xtest     = x((ntrain+1):end,:);
ytrain    = y(1:ntrain,:);
ytest     = y((ntrain+1):end,:);


% kernels parameters;
kernelparams.LINEAR = 1;            % include the linear kernel on all variables
kernelparams.FULL_LINEAR = 1 ;       % include linear kernels on each of the variables separately
kernelparams.CONSTANT = 1;          % include the constant kernel
kernelparams.IDENTITY = 1;           % include the identity matrix
kernelparams.POLYNOMIAL = 1;         % include polynomial kernel
kernelparams.FULL_GAUSSIAN = 1;      % include Gaussian kernels on all variables
kernelparams.SUBSET_GAUSSIAN = 1;    % include Gaussian kernels on subsets of variables
kernelparams.NSIGMAS = 5;           % number of width parameters for Gaussian kernels
kernelparams.MAXSUBSETS = 1;        % maximal size of subsets for Gaussian kernels
kernelparams.POLY_MAXORDER = 4;     % maximal order of polynomial kernel
kernelparams.SIGMAGRID = .2;      % spacing between values of the log width for Gaussian kernels

% compute kernel matrices and weights
[Ks_train,Ks_test,kernel_types] = create_path_kernel_matrices(xtrain,xtest,kernelparams);
m=length(Ks_train);                 % number of kernels

DS_POWER = 1;
ds = compute_ds(Ks_train,DS_POWER);

loss.type='logistic';
efficient_type=1;
Kse_train = build_efficient_Ks(Ks_train,efficient_type);
Kse_test = build_efficient_Ks_test(Ks_test,0);

% path following parameters
path_params.mu                  = 1e-3;      % parameter of log-barrier
path_params.EPS1                = 1e-10;     % precision parameters of Newton steps (very small and fixed)
path_params.EPS2                = 1e-2;      % precision parameter of tube around path (adaptive)
path_params.predictor_type      = 2;         % 1 : first order predictor, 2 : second order
path_params.efficient_predictor = 0;         % 1 : efficient predictor steps, 0 : full steps
path_params.efficient_eta       = 1;         % real value : threshold eta for corrector steps, 0 : no threshold
path_params.maxsigma            = 20;        % maximum value of sigma = -log(lambda);
path_params.newton_iter1        = 10;        % number of iterations with no modification
path_params.newton_iter2        = 6;         % delta number of iterations under which EPS2 is divided/multiplied by 2
path_params.maxdsigma           = 1;         % maximal step
path_params.mindsigma           = .004;      % minimal step
path_params.maxvalue_EPS2       = 1e-2;      % maximum value of tolerance for predictor steps



path = follow_entire_path(Kse_train,ytrain,loss,ds,path_params,Kse_test,ytest);

% plot
ind=1:2:size(path.etas,1);
rp=randperm(length(ind)); ind=ind(rp);
plot(path.sigmas,path.etas(ind,:),'-');
axis([ 0 10 0 11] )
xlabel('-log(\lambda)','fontsize',24)
ylabel('\eta ','fontsize',24)
