if boosted
%     switch predictor_type
%         case 0, newalpha = alpha + dsigma * (alpha_old-alpha)/(sigma_old-sigma);
%         case 1, newalpha = alpha + dsigma * da_dsigma + .5 * dsigma^2 * (da_dsigma_old-da_dsigma)/(sigma_old-sigma);
%         case 2, newalpha = alpha + dsigma * da_dsigma + dsigma^2 * .5 * d2a_dsigma2 + ...
%                 1/6 * dsigma^3 * (d2a_dsigma2_old-d2a_dsigma2)/(sigma_old-sigma);
%     end

    
        switch predictor_type
        case 0, newalpha = alpha ;
        case 1, newalpha = alpha + ( exp(dsigma) - 1 ) * da_dsigma;
        case 2, newalpha = alpha + ( exp(dsigma) - 1 ) * da_dsigma + ...
                +  .5 * ( exp(dsigma) - 1 )^2 * (  d2a_dsigma2 - da_dsigma );
    end

else
    switch predictor_type
        case 0, newalpha = alpha;
        case 1, newalpha = alpha+dsigma*da_dsigma;
        case 2, newalpha = alpha+dsigma*da_dsigma+ dsigma^2 * .5 * d2a_dsigma2;
    end
end
newlambda = exp(-sigma-dsigma);
if efficient_predictor
    [f,grad] = objective_function(Ks,y,loss,newalpha,ds,newlambda,mu);
    if isinf(f), lambda2 = Inf;
    else lambda2 = norm(hessianinvchol0'*grad)^2; end
else
    [f,grad,hessianinvchol0,eta,lambda2] = objective_function(Ks,y,loss,newalpha,ds,newlambda,mu);
end