function ds = compute_ds(Ks_train,DS_POWER)
% Compute the weights of the block 1-norm penalty
% assumes that kernels have unit trace
%
% ds = compute_ds(Ks_train,DS_POWER)
%
% INPUT
%  Ks_train : cell array of kernel matrices
%  DS_POWER : small integer, amount of compensation for the differing
%             intrinsic strengths of kernels

ntrain = size(Ks_train{1},1);
for k=1:length(Ks_train)
    % check unit trace
    if abs(trace(Ks_train{k})-1)>1e-6, k, error('not unit trace'); end
    q=eig(Ks_train{k});
    ds(k) = ( length(find(q>=.5 /ntrain ))).^( DS_POWER );
end
