function Kse = build_efficient_Ks(Ks,efficient_type)

% Build efficient representation of the kernel matrices
%
% Kse = build_efficient_Ks(Ks,efficient_type)
%
% INPUT
%             Ks = 1*k cell array of kernel matrices
% efficient_type = 0 -> not efficient
%                  1 -> efficient (recommended)
%
% OUTPUT
%            Kse = list of kernel matrices, in the format used
%                  by follow_entire_path

Kse.efficient_type = efficient_type ;
Kse.m = length(Ks);
Kse.n = size(Ks{1},1);
switch efficient_type
    case 0
        Kse.data = Ks;    
    case 1
        m = length(Ks);
        n = size(Ks{1},1);
        Kse.data = zeros(n*(n+1)/2,m);
        for j=1:m
            Kse.data(:,j) = symmetric_vectorize(Ks{j});
        end
end
