function xs=minimize_projected_gradient_dual_full_fast(x,optparam,xtilde,trA,kkk,subsample,lambda0,epsM,D,negative_constraints,missing_constraints);
[d p ] =size(xtilde);
nsub = length(subsample);
n = sum(D);

kmax = optparam.kmax;
display = optparam.display;
if isfield(optparam,'beta_ARMIJO'), beta_ARMIJO = optparam.beta_ARMIJO;
else, beta_ARMIJO = .25 ; end
if isfield(optparam,'sigma_ARMIJO'), sigma_ARMIJO = optparam.sigma_ARMIJO;
else, sigma_ARMIJO = .1 ; end
if isfield(optparam,'kmax_ARMIJO'), kmax_ARMIJO = optparam.kmax_ARMIJO;
else, kmax_ARMIJO = 20 ; end
if isfield(optparam,'tol_df'), tol_df = optparam.tol_df;
else, tol_df = 1e-7 ; end
if isfield(optparam,'tol'), tol = optparam.tol;
else, tol = 1e-6 ; end

k=1;
fs =Inf;
fx = Inf;
xs=[];
alpha=1;
while k<=kmax;
    % compute gradient
    [fx,gradient,M1,M2] = dual_cost_full_fast(x,xtilde,trA,kkk,subsample,lambda0,epsM,D,negative_constraints,missing_constraints);

    if k>1
        % stops if decrease or move is too small
        if  fx000 - fx < tol_df || norm(x-x000)<tol;
            break;
        end

    end
        x000 = x;
        fx000 = fx;

    if k==1, f00=fx; x00=x; end




    % projected gradient
    xbar = x -   gradient;
    d = - gradient;
    x0=x;
    ialpha = 1;
    while ialpha<kmax_ARMIJO
        xalpha = dual_projection_full(x + d * alpha,n,nsub,p);
        fxalpha = dual_cost_full_fast(xalpha,xtilde,trA,kkk,subsample,lambda0,epsM,D,negative_constraints,missing_constraints);
        if fx - fxalpha >= - sigma_ARMIJO * gradient' * ( xalpha - x );

            % start to go up
            while ( fx - fxalpha >= - sigma_ARMIJO * gradient' * ( xalpha - x ) ) & ialpha<kmax_ARMIJO;
                alpha = alpha / beta_ARMIJO;
                xalpha = dual_projection_full(x + d * alpha,n,nsub,p);
                fxalpha =  dual_cost_full_fast(xalpha,xtilde,trA,kkk,subsample,lambda0,epsM,D,negative_constraints,missing_constraints);
                % fprintf('+');
                ialpha = ialpha+1;
            end
            alpha = alpha * beta_ARMIJO;
            xalpha = dual_projection_full(x + d * alpha,n,nsub,p);
            x = xalpha;
            break;
        else
            alpha = alpha * beta_ARMIJO;

        end
        ialpha = ialpha+1;
    end
    if ialpha==kmax_ARMIJO, alpha=1; end



    if norm(x-x0)<1e-12, break; end
    if ~isinf(display)
        if display==1,
            fprintf('k=%d - f=%f - armijo=%d - dx=%e\n',k,fx,ialpha,norm(x-x0));
        end
        if display>1,
            if mod(k,display)==1
                fprintf('k=%d - f=%f - armijo=%d - dx=%e\n',k,fx,ialpha,norm(x-x0));

            end
        end
    end
    k=k+1;
end
if display>0
    [fx,gradient] = dual_cost_full_fast(x,xtilde,trA,kkk,subsample,lambda0,epsM,D,negative_constraints,missing_constraints);
     fprintf('k=%d - f=%f - armijo=%d - dx=%e\n',k,fx,ialpha,norm(x-x0));
end
xs=x;


