%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [f,subgradientDUAL,M1,M2] = dual_cost_full_fast(DUAL,xtilde,trA,kkk,subsample,lambda0,epsM,D,negative_constraints,missing_constraints);
nsub = length(subsample);
p = size(xtilde,2);
n = sum(D);

jjj = floor(n/lambda0);
nneg = size(negative_constraints,1);

% transform dual vector to dual variables
N=vector2matrix(DUAL(1: nsub * (nsub-1)/2),nsub);
udual = DUAL(nsub * (nsub-1)/2+1:nsub * (nsub-1)/2+p);
vdual = DUAL(nsub * (nsub-1)/2+1+p:nsub * (nsub-1)/2+p+p);
mu = DUAL(nsub * (nsub-1)/2+1+p+p:nsub * (nsub-1)/2+p+p+p);
if nneg>0
    Nneg = DUAL(nsub * (nsub-1)/2+p+p+p+1:nsub * (nsub-1)/2+p+p+p+nneg);

end
b = DUAL(end-1);
c = DUAL(end);
if c<1e-12, f=Inf; subgradient = NaN; M1=NaN; M2=NaN; return; end

if missing_constraints(1), N = N*0; end
if missing_constraints(2), b = b*0; end
if missing_constraints(3), mu = mu*0; end

global u_diffrac;
global j_diffrac;

eig_is_ok = 0;
eig_try = 0 ;
eig_increment = 0;

while ~eig_is_ok,
    if norm(mu)<1e-12 & norm(udual)<1e-12 & norm(vdual)<1e-12,
        % we have a matrix of the form identity - low-rank
        % only happens at initialization -> get the eigenvalues directly
        AA = [ 1/sqrt(trA * n) * ones(p,1) , 1/sqrt(trA) * xtilde', sqrt(b*b / c / n / n / n) * D.^.5 ];
        [u,e,v]=svd(AA,'econ');
        e = 1/trA *eye(size(e,1)) - e.^2;
        neigs = size(xtilde,1)+2;
    else

        if eig_try == 0, % first try
            % heuristics for determining number of eigenvalues -> may need to recompute more...
            if p <= 75,
                neigs=p;    % if small dimensions, use p
            elseif j_diffrac > 0,
                neigs = j_diffrac+kkk;  % if known previous number of used eigenvalues, use the same + a few
            elseif size(xtilde,1) > 2*jjj,
                neigs = 2*jjj;  % large dimensions
            else
                neigs = (size(xtilde,1))+2*jjj; % small dimensions
            end
        else
            neigs = neigs + eig_increment;
        end

        % computing eigenvalues
        if neigs>p/2
            % get all eigenvalues -> build the full matrix
            neigs=p;
            B = eye(p) - D.^.5 * (D.^.5)' /n - xtilde' * xtilde;
            B = B /trA  + 1/n*diag(mu) - b*b / c / n / n / n * (D.^.5) * (D.^.5)';
            B = B - D.^.5 *  ( udual .* D.^.5)'/ n/2/n - ( udual .* D.^.5) * ( D.^.5)' / n/2/n;
            B = B - D.^.5 *  ( - vdual .* D.^.5)'/ n/2/n - ( -vdual .* D.^.5) * ( D.^.5)' / n/2/n;
            if nsub >0
                B(subsample,subsample) = B(subsample,subsample) - 1/nsub/nsub*2*(  N - eye(nsub) );
            end
            if nneg > 0
                for i=1:nneg
                    B( negative_constraints(i,1):negative_constraints(i,2))  = B( negative_constraints(i,1):negative_constraints(i,2))  ...
                        - Nneg(i)/(D(negative_constraints(i,1))*D(negative_constraints(i,2)));
                    B( negative_constraints(i,2):negative_constraints(i,1))  = B( negative_constraints(i,2):negative_constraints(i,1))  ...
                        - Nneg(i)/(D(negative_constraints(i,1))*D(negative_constraints(i,2)));
                end
            end
            [u,e] = eig(B);
        else
            % only get parts of the spectrum
            OPTS.issym = 1;
            OPTS.disp = 0;
            OPTS.tol = 1e-10;
            OPTS.maxit = 100;
            % [u,e] = eigs(B,neigs,'SA',OPTS);
            if nneg==0

                [u,e,flag] = eigs('eig_fun_dual_cost_full',p,neigs,'SA',OPTS,n,nsub,sqrt(1/trA)*xtilde,1/n*mu+1/trA,1/trA/n,sqrt(b*b/c/n/n/n)*D.^.5,subsample,N,1/(nsub+1)/(nsub+1)*2,D.^.5,D.^.5.*(udual-vdual)/n/2/n);
            else

                [u,e,flag] = eigs('eig_fun_dual_cost_neg_full',p,neigs,'SA',OPTS,n,nsub,sqrt(1/trA)*xtilde,1/n*mu+1/trA,1/trA/n,sqrt(b*b/c/n/n/n)*D.^.5,subsample,N,1/(nsub+1)/(nsub+1)*2,negative_constraints,Nneg./(D(negative_constraints(:,1)).*D(negative_constraints(:,2))),D.^.5,D.^.5.*(udual-vdual)/n/2/n);
            end
            if flag

                % has not converged -> start again
                OPTS.issym = 1;
                OPTS.disp = 0;
                OPTS.tol = 1e-10;
                OPTS.maxit = 1000;
                % [u,e] = eigs(B,neigs,'SA',OPTS);
                if nneg==0
                    [u,e,flag] = eigs('eig_fun_dual_cost_full',p,neigs,'SA',OPTS,n,nsub,sqrt(1/trA)*xtilde,1/n*mu+1/trA,1/trA/n,sqrt(b*b/c/n/n/n)*D.^.5,subsample,N,1/(nsub+1)/(nsub+1)*2,D.^.5,D.^.5.*(udual-vdual)/n/2/n);
                else
                    [u,e,flag] = eigs('eig_fun_dual_cost_neg_full',p,neigs,'SA',OPTS,n,nsub,sqrt(1/trA)*xtilde,1/n*mu+1/trA,1/trA/n,sqrt(b*b/c/n/n/n)*D.^.5,subsample,N,1/(nsub+1)/(nsub+1)*2,negative_constraints,Nneg./(D(negative_constraints(:,1)).*D(negative_constraints(:,2))),D.^.5,D.^.5.*(udual-vdual)/n/2/n);
                end

                if flag, disp('eigensolver has not coverged');
                    % this usually means that all missing eigenvalues are constant -> use initial estimate
                    if norm(mu)<.1 & norm(udual)<.1 & norm(vdual)<.1,
                        % we have a matrix of the form identity - low-rank
                        % only happens at initialization -> get the eigenvalues directly
                        AA = [ 1/sqrt(trA * n) * ones(p,1) , 1/sqrt(trA) * xtilde', sqrt(b*b / c / n / n / n) * D.^.5 ];
                        [u,e,v]=svd(AA,'econ');
                        e = 1/trA *eye(size(e,1)) - e.^2;
                        neigs = size(xtilde,1)+2;
                    else
                        keyboard
                    end




                end
            end
        end
    end
    e = real(e); u=real(u);
    [a,bb]=sort(diag(e));
    epsM = epsM/n;
    M1 = u(:,bb);



    [Mopt,I1,I2,I3]=compute_spectral_function_new(a,epsM,lambda0,kkk,n);
    M2 = Mopt;


    if isempty(Mopt)
        % need more eigenvalues
        if (eig_try == 0)
            eig_increment = neigs;

        end
        eig_try =  eig_try  + 1;
    else
        eig_is_ok = 1;
    end
end

IA = union(I1,union(I2,I3));

M1 = u(:,IA);
M2 = M2(IA);


f = sum( a(IA).* M2 )+ epsM /2/lambda0 * sum(M2.^2) - 2 * b  / n  - kkk*c /n  - D'*mu / n + lambda0 * D'* udual / n/n - (n-(kkk-1)*lambda0) * D' * vdual /n/n;

sumMopt = M1' * (D.^.5); sumMopt = sum( sumMopt.^2 .* M2 );
sumMoptu = M1' * (D.^.5 );
sumMoptu = D.^.5 .* ( M1 * ( M2 .* sumMoptu ) ) ;
sumMoptv = M1' * (D.^.5 );
sumMoptv =  D.^.5 .* ( M1 * ( M2 .* sumMoptv ) ) ;
diagMopt = sum( M1.^2 .* repmat(M2',size(M1,1),1) , 2);
subgradientb = -2 * sumMopt * b / c / n / n / n  - 2  / n ;
subgradientc = sumMopt * b * b / c / c / n / n / n  - kkk / n ;
subgradientmu = 1/n*diagMopt - D/n;
subgradientudual = - 1/n/n * sumMoptu + lambda0 * D / n/n;
subgradientvdual = + 1/n/n * sumMoptv - (n-(kkk-1)*lambda0) * D / n/n;

temp=M1(subsample,:);
subgradientN = - 1/(nsub+1)/(nsub+1)*2 * temp * ( repmat(M2,1,nsub) .* temp' );
if nneg>0
    subgradientNneg = zeros(nneg,1);
    for i=1:nneg
        subgradientNneg(i) = - 2/(D(negative_constraints(i,1))*D(negative_constraints(i,2)))* sum( M1(negative_constraints(i,1),:) .* M2' .* M1(negative_constraints(i,2),:));
    end
end
if missing_constraints(1), subgradientN = subgradientN*0; end
if missing_constraints(2), subgradientb = subgradientb*0; end
if missing_constraints(3), subgradientmu = subgradientmu*0; end


subgradientDUAL = zeros( nsub * (nsub-1)/2 + p + 1 + 1 + nneg +p+p, 1);
subgradientDUAL(1: nsub * (nsub-1)/2) = matrix2vector(subgradientN,nsub)*2;
subgradientDUAL(nsub * (nsub-1)/2+1:nsub * (nsub-1)/2+p) = subgradientudual;
subgradientDUAL(nsub * (nsub-1)/2+1+p:nsub * (nsub-1)/2+p+p) = subgradientvdual;
subgradientDUAL(nsub * (nsub-1)/2+1+p+p:nsub * (nsub-1)/2+p+p+p) = subgradientmu;
subgradientDUAL(end-1) = subgradientb;
subgradientDUAL(end) = subgradientc;      % c parameter
if nneg>0
    subgradientDUAL(nsub * (nsub-1)/2+p+p+p+1:nsub * (nsub-1)/2+p+p+p+nneg) = subgradientNneg;
end
f = - f;
subgradientDUAL = - subgradientDUAL;
%  Us = M1 * diag(M2.^.5);
% norm( diag(Us*Us') - D )
% remultiply back to actual M1
M1 = repmat( D.^-.5,1,size(M1,2) ) .* M1;
%  Us = M1 * diag(M2.^.5);
% norm( diag(Us*Us') - 1 )

