function [Mopt,I1,I2,I3]=compute_spectral_function_new(a,epsM,lambda0,kkk,n)

neigs = length(a);  % number of available eigenvalues
Mopt = [];
% iterate over all possible max(I1)
for maxI1 = kkk:neigs

    % try all possible additional for max(I2)
    for maxI2 = 0:min(floor(n/lambda0),maxI1)

        for maxI3 = 0:maxI2

            I3 = [ 1:maxI3 ] ;
            I2 = [ maxI3+1:maxI2 ];
            I1  = [ maxI2+1:maxI1 ];

            % test if there is a stationary point inside, by computing derivatives
            dmu_0 = kkk * lambda0;
            dmu_nu = 0;
            dmu_mu = 0;
            dnu_0 =  - n;
            dnu_nu = 0;
            dnu_mu = 0;

            % derivative for I1
            dmu_0 = dmu_0 + lambda0/epsM * sum(a(I1));
            dmu_nu = dmu_nu + lambda0/epsM * length(I1);
            dmu_mu = dmu_mu - lambda0/epsM * length(I1);
            dnu_0 = dnu_0 - lambda0/epsM * sum(a(I1));
            dnu_nu = dnu_nu - lambda0/epsM * length(I1);
            dnu_mu = dnu_mu + lambda0/epsM * length(I1);

            % derivative for I2
            dmu_0 = dmu_0 - length(I2)*lambda0;
            dnu_0 = dnu_0 + length(I2)*lambda0;

            % derivative for I3
            dmu_0 = dmu_0 - length(I3)*lambda0;
            dnu_0 = dnu_0 - lambda0/epsM * sum(a(I3));
            dnu_nu = dnu_nu - lambda0/epsM * length(I3);


            optimal = 0;
            if ~isempty(I3) & ~isempty(I1)
                % look at nice cases where the system has unique solution
                det = ( dmu_mu * dnu_nu - dmu_nu * dnu_mu );
                nu = - ( dmu_mu * dnu_0 - dmu_0 * dnu_mu ) / det;
                mu = - ( dmu_0 * dnu_nu - dmu_nu * dnu_0 ) / det;
    
                
                % check constraints
                if all(a(I1) + nu - mu <= 1e-12) * all( a(I1) + nu - mu +  epsM >= -1e-12 ) ...
                        * all( a(I2) + nu - mu +  epsM <= 1e-12 ) * all( a(I2) + nu +  epsM  >= -1e-12 ) ...
                        * all( a(I3) + nu +  epsM  <= 1e-12 )
                    optimal = 1;
                end

            elseif isempty(I3) & isempty(I1)
                % rare ( may only occur if k*lambda0=n )
                if (length(I2) == kkk) &  abs( kkk * lambda0 - n ) < 1e-12,
                    optimal = 1;
                    mu = 0; nu = 0;
                end

            elseif isempty(I3)

                if abs( kkk * lambda0 - n ) < 1e-12,
                    nu_mu =  - dmu_0 / dmu_nu;
                    if all(a(I1) + nu_mu <= 1e-12) * all( a(I1) + nu_mu +  epsM >= -1e-12 ) ...
                            * all( a(I2) + nu_mu +  epsM <= 1e-12 )
                        optimal = 1;
                        mu = 0; nu = nu_mu;
                    end
                end

            elseif isempty(I1)

                nu =  - dnu_0 / dnu_nu;
              mu = 0; % irrelevant value

                if (length(I2)+length(I3))>=kkk
                    
                    

                    if ( all( a(I2) + nu +  epsM  >= -1e-12 ) ...
                            & all( a(I3) + nu +  epsM  <= 1e-12 ) )
                        optimal = 1;

                    end
                end
            end


            if optimal
                Mopt = zeros(neigs,1);
                Mopt(I2) = lambda0;
                Mopt(I1) = - lambda0 /epsM * ( a(I1) + nu-mu);
                Mopt(I3) = - lambda0 /epsM * ( a(I3) + nu);


                return;
            end
        end
    end
end


