% DEMONSTRATION OF SEMI-SUPERVISED CLASSIFICATION WITH DIFFRAC

% WITH SUPERVISION (POSITIVE CONSTRAINTS ONLY)
% FAMOUS TWO MOONS
seed=1;
rand('state',seed);
randn('state',seed);
n1 = 400;
n2 = 400;
angle = (1:n1)*(pi/n1) + randn(1,n1)*.1;
radius = 3*ones(1,n1) + randn(1,n1)*.65;
x1 = [ radius .* cos(angle); radius .* sin(angle) ];
angle = -(1:n2)*(pi/n2) + randn(1,n2)*.1;
radius = 3*ones(1,n2) + randn(1,n2)*.65;
x2 = [ 3+radius .* cos(angle); 1  + radius .* sin(angle) ];
x = [x1 x2]';
z = [ones(n1,1); 2*ones(n2,1);];


[Us,z,y,output] = diffrac(x,2,'kernel_type','rbf','kernel_parameters',1,'df',30);
subplot(2,2,1);
plot_partitions(x',z);
title('DIFFRAC - NO SUPERVISION');

nsup=10;
rp1 = randperm(n1);
rp2 = randperm(n2);
ysup1 = rp1(1:nsup);
ysup2 = rp2(1:nsup);
zsup = z*0+3; zsup(ysup1)=1; zsup(ysup2+n1)=2;
subplot(2,2,2);
plot_partitions(x',zsup)
title('LABELLED POINTS');

positive_constraints = [ [ ysup1(1)*ones(nsup,1) ysup1' ]; [ ysup2(1)*ones(nsup,1) ysup2' ]+n1 ];
[Us,z,y,output] = diffrac(x,2,'kernel_type','rbf','kernel_parameters',.5,'df',30,'positive_constraints',positive_constraints,'labelled_option',1);
subplot(2,2,3);
plot_partitions(x',z);
title('DIFFRAC - POSITIVE CONSTRAINTS');


labelled = z*0;
labelled([ ysup1, ysup2+n1 ])=z([ ysup1, ysup2+n1 ]);
[Us,z,y,output] = diffrac(x,2,'kernel_type','rbf','kernel_parameters',.5,'df',30,'labelled_option',1,...
    'labelled',labelled);


subplot(2,2,4);
plot_partitions(x',z);
title('DIFFRAC - SSL CONSTRAINTS');

