% DEMONSTRATION SCRIPT FOR DIFFRAC - LINEAR AND NON LINEAR


% LINEAR - NO SUPERVISION
seed=1;
rand('state',seed);
randn('state',seed);
n = 400;
d = 2;
f = 20;
x = [ randn(n/2,d) + repmat([ 3 0 ],n/2,1); ...
     randn(n/2,d) + repmat([ -3 0 ],n/2,1) ];
x = [ x, randn(n,f) ];
plot(x(:,1),x(:,2),'x');

[Us,z,y,output] = diffrac(x,2,'kernel_type','linear','lambda',1e-6)
subplot(2,2,1)
plot_partitions(x',z);
title('linear - no supervision');

% note the following: this is useful (i.e., faster) to warm restart the algoritm
[Us,z,y,output] = diffrac(x,2,'kernel_type','linear','lambda',1e-6,'warm_restart',output.DUAL);


% LINEAR - WITH SUPERVISION (POSITIVE CONSTRAINTS ONLY)
nsup = 40;
positive_constraints = [ [ ones(nsup,1) (2:nsup+1)' ]; [ n*ones(nsup,1) (n-nsup:n-1)' ] ];
[Us,z,y,output] = diffrac(x,2,'kernel_type','linear','lambda',1e-6,'labelled_option',1,'positive_constraints',positive_constraints);
subplot(2,2,2)
plot_partitions(x',z);
title('linear - with supervision');





% FAMOUS TWO MOONS
seed=1;
rand('state',seed);
randn('state',seed);
n1 = 150;
n2 = 150;
n = n1+n2;
angle = (1:n1)*(pi/n1) + randn(1,n1)*.1;
radius = 3*ones(1,n1) + randn(1,n1)*.65;
x1 = [ radius .* cos(angle); radius .* sin(angle) ];
angle = -(1:n2)*(pi/n2) + randn(1,n2)*.1;
radius = 3*ones(1,n2) + randn(1,n2)*.65;
x2 = [ 3+radius .* cos(angle); 0.75  + radius .* sin(angle) ];
x = [x1 x2]';
z = [ones(n1,1); 2*ones(n2,1);];
% note the following: this is useful (i.e., faster) to warm restart the algoritm
[Us,z,y,output] = diffrac(x,2,'kernel_type','rbf','kernel_parameters',1,'df',30);
subplot(2,2,3)
plot_partitions(x',z);
title('non linear - no supervision');


% LINEAR - WITH SUPERVISION (POSITIVE CONSTRAINTS ONLY)
nsup = 25;
rp1 = randperm(n1);
rp2 = randperm(n1);
rp3 = randperm(n2);
rp4 = randperm(n2);

positive_constraints = [ [ rp1(1:nsup)' rp2(1:nsup)' ]; [ n+1-rp3(1:nsup)' n+1-rp4(1:nsup)' ] ];
[Us,z,y,output] = diffrac(x,2,'kernel_type','rbf','kernel_parameters',1,'df',30,'labelled_option',1,'positive_constraints',positive_constraints);
subplot(2,2,4)
plot_partitions(x',z);
title('non linear - with supervision');






